/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.contract;

import net.vavilon.Node;
import net.vavilon.token.TokenUtils;
import net.vavilon.token.model.Account;
import net.vavilon.token.model.Transaction;

public class EpochFinish
extends TokenUtils {
    public static final String GAS_SEED = "nation finger unable fade exist visa arch awake anchor surround paddle rifle";
    public static final String GAS_PASSWORD = EpochFinish.hash("nation finger unable fade exist visa arch awake anchor surround paddle rifle");
    public static final String GAS_ADDRESS = EpochFinish.hashAddress(GAS_PASSWORD);
    Transaction lastEpochTran = null;

    Transaction getEpochTran() {
        Transaction epochTran = null;
        Transaction result = null;
        String prevKey = null;
        String nextHash = null;
        if (this.lastEpochTran != null) {
            epochTran = this.lastEpochTran;
        }
        while (nextHash == null || epochTran != null) {
            result = epochTran;
            String[] pass = EpochFinish.tokenPass("usdt", GAS_ADDRESS, GAS_PASSWORD, prevKey).split(":");
            prevKey = pass[0];
            nextHash = pass[1];
            epochTran = (Transaction)transByHash.get(nextHash);
        }
        this.lastEpochTran = epochTran;
        return result;
    }

    @Override
    public void run() {
        Double epoch_vavilon_stop_balance = this.getDoubleRequired("epoch_vavilon_stop_balance");
        Transaction epochTran = this.getEpochTran();
        Double nextEpochReward = EpochFinish.round((epochTran == null ? (Node.isDebugMode ? 0.001 : 10.0) : epochTran.amount) * 1.01);
        String epochAddress = epochTran == null ? null : epochTran.to;
        double gasBalance = EpochFinish.getBalanceOrZero("usdt", GAS_ADDRESS);
        double participantsBalance = EpochFinish.getBalanceOrZero("vavilon", epochAddress);
        if (epochAddress != null && participantsBalance == 0.0) {
            EpochFinish.error("epoch vavilon balance is zero");
        }
        if (gasBalance >= nextEpochReward && participantsBalance == epoch_vavilon_stop_balance) {
            if (epochTran != null) {
                if (participantsBalance > 0.0) {
                    for (String next_hash : userTrans.getLastStringList(epochAddress, 1000L)) {
                        Transaction tran = (Transaction)transByHash.get(next_hash);
                        if (tran.amount == 0.0 || !tran.domain.equals("vavilon")) continue;
                        double rewardForAddress = EpochFinish.roundDown(epochTran.amount * (tran.amount / participantsBalance));
                        this.tokenSend(this.scriptPath, "usdt", epochAddress, tran.from, rewardForAddress, EpochFinish.tokenPass("usdt", epochAddress, GAS_PASSWORD), null);
                        this.tokenSend(this.scriptPath, "vavilon", epochAddress, tran.from, tran.amount, EpochFinish.tokenPass("vavilon", epochAddress, GAS_PASSWORD), null);
                    }
                }
                Account epochGas = this.getAccountChanced("usdt", epochAddress);
                if (epochGas.balance > 0.0) {
                    this.tokenSend(this.scriptPath, "usdt", epochAddress, GAS_ADDRESS, epochGas.balance, this.tokenPassCached("usdt", epochAddress, GAS_PASSWORD), null);
                }
            }
            String nextEpochAddress = EpochFinish.address(EpochFinish.tokenPass("usdt", GAS_ADDRESS, GAS_PASSWORD, epochTran == null ? null : epochTran.prev_key).split(":")[1]);
            this.regAccount(this.scriptPath, "usdt", nextEpochAddress, GAS_PASSWORD, "mfm-contract/epoch_finish");
            this.regAccount(this.scriptPath, "vavilon", nextEpochAddress, GAS_PASSWORD, "mfm-contract/epoch_finish");
            this.tokenSend(this.scriptPath, "usdt", GAS_ADDRESS, nextEpochAddress, nextEpochReward, EpochFinish.tokenPass("usdt", GAS_ADDRESS, GAS_PASSWORD), null);
        } else {
            EpochFinish.error("epoch is not finished");
        }
    }
}

