/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.contract;

import java.math.BigInteger;
import java.util.List;
import net.vavilon.contract.Contract;
import net.vavilon.servers.WssServer;
import net.vavilon.token.model.Token;
import net.vavilon.utils.Request;

public abstract class Mint
extends Contract {
    public static final String MINING_SEED = "card wing home athlete regular post notice paddle isolate zone payment chef";
    public static final String MINING_PASSWORD = Mint.hash("card wing home athlete regular post notice paddle isolate zone payment chef");
    public static final String MINING_ADDRESS = Mint.hashAddress(MINING_PASSWORD);

    abstract double getPercentInYear();

    abstract long needIntervalSec();

    private double calcReward(String domain) {
        double minutesInYear = 525600.0;
        return Mint.round(Mint.getBalanceOrZero(domain, MINING_ADDRESS) / this.getPercentInYear() / minutesInYear);
    }

    @Override
    public void run() {
        String domain = this.getRequired("domain");
        String gas_address = this.getRequired("gas_address");
        Long nonce = this.getLongRequired("nonce");
        Long time = this.getTimeRequired("time");
        this.emulateTime(time);
        String lastHash = this.dataGet("mining/" + domain + "/last_hash");
        Long difficulty = this.dataGetLong("mining/" + domain + "/difficulty", 1L);
        Long lastTime = this.dataGetLong("mining/" + domain + "/last_time", 0L);
        String str = lastHash + domain + nonce;
        String newHash = Mint.hash(str);
        BigInteger hashNumber = new BigInteger(newHash, 16);
        hashNumber = hashNumber.mod(BigInteger.valueOf(difficulty));
        if (hashNumber.equals(BigInteger.ZERO)) {
            double reward = this.calcReward(domain);
            this.tokenSend(this.scriptPath, domain, MINING_ADDRESS, gas_address, reward, Mint.tokenPass(domain, MINING_ADDRESS, MINING_PASSWORD), null);
            long interval = time - (lastTime == null ? 0L : lastTime);
            long timeDiff = interval - this.needIntervalSec();
            int axelerate = 0;
            List<Long> difficultyHistory = this.dataHistoryLong("mining/" + domain + "/difficulty", 20);
            for (int i = 0; i < difficultyHistory.size() - 1; ++i) {
                if (difficultyHistory.get(i) > difficultyHistory.get(i + 1)) {
                    ++axelerate;
                }
                if (difficultyHistory.get(i) >= difficultyHistory.get(i + 1)) continue;
                --axelerate;
            }
            int difficultyDiff = (int)Math.pow(2.0, Math.abs(axelerate));
            if (timeDiff == 0L) {
                difficultyDiff = 0;
            } else if (timeDiff > 0L) {
                difficultyDiff = -difficultyDiff;
            }
            difficulty = difficulty + (long)difficultyDiff;
            if (difficulty < 1L) {
                difficulty = 1L;
            }
            this.dataSet("mining/" + domain + "/difficulty", "" + difficulty);
            this.dataSet("mining/" + domain + "/last_hash", newHash);
            this.dataSet("mining/" + domain + "/last_time", "" + time);
            this.trackLinear(domain + "_difficulty", difficulty.longValue());
            Token token = Mint.getToken(domain);
            token.difficulty = difficulty;
            this.setToken(token);
            WssServer.broadcast("mining:" + domain, Request.map("domain", domain, "difficulty", "" + difficulty, "lastHash", lastHash, "reward", "" + reward, "gas_address", gas_address));
            this.response.put("minted", reward);
        } else {
            Mint.error("invalid nonce");
        }
    }
}

