/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.contract;

import net.vavilon.contract.PoolAdd;

public class PoolImpact
extends PoolAdd {
    public Double calculatePriceImpact(String domain, Boolean isSell, Double amount) {
        Double x = this.poolTokens(domain);
        Double y = this.poolGas(domain);
        if (x == 0.0 || y == 0.0) {
            return 0.0;
        }
        Double k = x * y;
        if (isSell.booleanValue()) {
            Double newX = x + amount;
            Double newY = k / newX;
            return (y - newY) / y;
        }
        Double newY = y + amount;
        Double newX = k / newY;
        return (x - newX) / x;
    }

    @Override
    public void run() {
        String domain = this.getRequired("domain");
        Long is_sell = this.getLong("is_sell");
        Double amount = this.getDouble("amount");
        this.response.put("price", this.poolPrice(domain));
        this.response.put("pool_address", this.poolAddress(domain));
        this.response.put("pool_token", this.poolTokens(domain));
        this.response.put("pool_gas", this.poolGas(domain));
        if (amount != null && is_sell != null) {
            this.response.put("amount_out", this.calculateSwap(domain, is_sell == 1L, amount));
            this.response.put("price_impact", PoolImpact.round(this.calculatePriceImpact(domain, is_sell == 1L, amount) * 100.0));
        }
    }
}

