/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.servers;

import java.io.File;
import java.util.Collections;
import org.apache.ftpserver.DataConnectionConfigurationFactory;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.ClearTextPasswordEncryptor;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;

public class FtpServer {
    private final int ftpPort;
    private final int passiveStartPort;
    private final int passiveEndPort;
    private org.apache.ftpserver.FtpServer server;

    public FtpServer(int ftpPort, int passiveStartPort, int passiveEndPort) {
        this.ftpPort = ftpPort;
        this.passiveStartPort = passiveStartPort;
        this.passiveEndPort = passiveEndPort;
    }

    public void start() {
        try {
            FtpServerFactory serverFactory = new FtpServerFactory();
            ListenerFactory factory = new ListenerFactory();
            DataConnectionConfigurationFactory dataConFactory = new DataConnectionConfigurationFactory();
            dataConFactory.setPassivePorts(this.passiveStartPort + "-" + this.passiveEndPort);
            factory.setDataConnectionConfiguration(dataConFactory.createDataConnectionConfiguration());
            factory.setPort(this.ftpPort);
            serverFactory.addListener("default", factory.createListener());
            PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
            userManagerFactory.setPasswordEncryptor(new ClearTextPasswordEncryptor());
            UserManager um = userManagerFactory.createUserManager();
            BaseUser user = new BaseUser();
            user.setName("admin");
            user.setPassword("password");
            user.setHomeDirectory(new File(".").getAbsolutePath());
            user.setAuthorities(Collections.singletonList(new WritePermission()));
            um.save(user);
            serverFactory.setUserManager(um);
            this.server = serverFactory.createServer();
            this.server.start();
            System.out.println("FTP started on port: " + factory.getPort());
        }
        catch (Exception e) {
            System.out.println("FTP failed to start: " + e.getMessage());
        }
    }
}

