/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.servers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.vavilon.servers.model.ContractException;
import net.vavilon.servers.model.Endpoint;
import net.vavilon.utils.Utils;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.Callback;

public class HttpHandler
extends AbstractHandler {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final EndpointSever endpointSever;

    public HttpHandler(EndpointSever endpointSever) {
        this.endpointSever = endpointSever;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        response.getHeaders().put("Content-Type", "application/json;charset=utf-8");
        String scriptPath = request.getHttpURI().getPath().substring(1);
        Endpoint endpoint = this.endpointSever.getEndpoint(scriptPath);
        if (endpoint == null) {
            return false;
        }
        Map<String, Object> params = this.parseParams(request);
        try {
            endpoint.run(scriptPath, params);
        }
        catch (Exception e) {
            LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
            error.put("params", params);
            error.put("message", e.getMessage());
            if (e instanceof ContractException) {
                error.put("data", ((ContractException)e).data);
            }
            error.put("message", e.getMessage());
            error.put("stack", Utils.getStackTrace(e));
            String responseStr = gson.toJson(error);
            System.out.println("error: " + responseStr);
            response.setStatus(500);
            response.write(true, ByteBuffer.wrap(responseStr.getBytes(StandardCharsets.UTF_8)), callback);
            return true;
        }
        endpoint.response.put("success", "true");
        System.out.println("success: " + scriptPath);
        response.setStatus(200);
        response.write(true, ByteBuffer.wrap(gson.toJson(endpoint.response).getBytes(StandardCharsets.UTF_8)), callback);
        return true;
    }

    private Map<String, Object> parseParams(Request request) throws IOException {
        String body;
        if (request.getMethod().equals("GET")) {
            return HttpHandler.parseQueryString(request.getHttpURI().getQuery());
        }
        if (request.getMethod().equals("POST") && Utils.isNotEmpty(body = Content.Source.asString(request, StandardCharsets.UTF_8))) {
            try {
                return (Map)gson.fromJson(body, new TypeToken<Map<String, String>>(){}.getType());
            }
            catch (Exception e) {
                return net.vavilon.utils.Request.map("body", body);
            }
        }
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> parseQueryString(String query) {
        LinkedHashMap<String, Object> queryParams = new LinkedHashMap<String, Object>();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                String[] keyValue = pair.split("=");
                if (keyValue.length != 2) continue;
                queryParams.put(keyValue[0], keyValue[1]);
            }
        }
        return queryParams;
    }

    public static interface EndpointSever {
        public Endpoint getEndpoint(String var1);
    }
}

