/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.servers;

import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import net.vavilon.servers.FtpServer;
import net.vavilon.servers.HttpHandler;
import net.vavilon.servers.WssServer;
import net.vavilon.servers.model.Endpoint;
import net.vavilon.servers.model.Subscription;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.ee10.websocket.server.JettyWebSocketServletFactory;
import org.eclipse.jetty.ee10.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.eclipse.jetty.rewrite.handler.RedirectPatternRule;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public abstract class HttpServer
implements HttpHandler.EndpointSever,
WssServer.Callback {
    protected Server server = new Server();

    @Override
    public abstract Endpoint getEndpoint(String var1);

    public HttpServer() throws Exception {
        HttpConfiguration http_config = new HttpConfiguration();
        ForwardedRequestCustomizer forwarded = new ForwardedRequestCustomizer();
        http_config.addCustomizer(forwarded);
        int acceptorCount = 8;
        int selectorCount = -1;
        Duration idleTimeout = Duration.of(3L, ChronoUnit.MINUTES);
        ServerConnector http = new ServerConnector(this.server, null, null, null, acceptorCount, selectorCount, new HttpConnectionFactory(http_config));
        http.setPort(80);
        http.setIdleTimeout(idleTimeout.toMillis());
        http.setAcceptQueueSize(8);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath("keystore.jks");
        sslContextFactory.setKeyStorePassword("x29a100");
        sslContextFactory.setKeyManagerPassword("x29a100");
        HttpConfiguration https_config = new HttpConfiguration(http_config);
        https_config.addCustomizer(new SecureRequestCustomizer());
        ServerConnector https = new ServerConnector(this.server, new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https_config));
        https.setPort(443);
        https.setIdleTimeout(idleTimeout.toMillis());
        https.setAcceptQueueSize(8);
        this.server.setConnectors(new Connector[]{http, https});
        Path root = new File(".").toPath().toRealPath(new LinkOption[0]);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setBaseResourceAsString(root.toString());
        resourceHandler.setWelcomeFiles("index.html");
        ContextHandler staticHandler = new ContextHandler("/");
        staticHandler.setHandler(resourceHandler);
        staticHandler.insertHandler(new Handler.Wrapper(){

            @Override
            public boolean handle(Request request, Response response, Callback callback) throws Exception {
                response.getHeaders().add("Content-Security-Policy", "frame-src 'none'");
                response.getHeaders().add("X-Frame-Options", "DENY");
                return super.handle(request, response, callback);
            }
        });
        ContextHandler redirectHandler = new ContextHandler("/");
        RewriteHandler rewrite = new RewriteHandler();
        RedirectPatternRule redirect = new RedirectPatternRule();
        redirect.setPattern("");
        redirect.setLocation("/mfm-landing/");
        rewrite.addRule(redirect);
        redirectHandler.setHandler(rewrite);
        ContextHandler apiHandler = new ContextHandler("/");
        apiHandler.setHandler(new HttpHandler(this));
        ServletContextHandler wsHandler = new ServletContextHandler();
        wsHandler.addServlet(new ServletHolder(new JettyWebSocketServlet(){

            @Override
            protected void configure(JettyWebSocketServletFactory factory) {
                factory.setIdleTimeout(Duration.ofMinutes(5L));
                factory.addMapping("/", (req, res) -> new WssServer(HttpServer.this));
            }
        }), "/ws");
        JettyWebSocketServletContainerInitializer.configure(wsHandler, null);
        ContextHandlerCollection handlers = new ContextHandlerCollection(new ContextHandler[0]);
        handlers.addHandler(redirectHandler);
        handlers.addHandler(staticHandler);
        handlers.addHandler(apiHandler);
        handlers.addHandler(wsHandler);
        this.server.setHandler(handlers);
    }

    public void start() throws Exception {
        new FtpServer(21, 50000, 50100).start();
        this.server.start();
    }

    @Override
    public void onMessage(Subscription sub) {
    }
}

