/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.token;

import java.util.LinkedHashMap;
import net.vavilon.contract.Mint;
import net.vavilon.token.TokenEndpoint;

public class TokenInfo
extends TokenEndpoint {
    @Override
    public void run() {
        super.run();
        String domain = this.getRequired("domain");
        String address = this.getString("address");
        this.response.put("gas_account", TokenInfo.getAccount("usdt", address));
        this.response.put("owner", TokenInfo.getAccount(domain, "owner"));
        this.response.put("mining", TokenInfo.getAccount(domain, Mint.MINING_ADDRESS));
        LinkedHashMap<String, Double> analytics = new LinkedHashMap<String, Double>();
        analytics.put("trans", TokenInfo.getCandleLastValue(domain + "_trans"));
        analytics.put("accounts", TokenInfo.getCandleLastValue(domain + "_accounts"));
        analytics.put("trans7d", this.getCandleChange7d(domain + "_trans"));
        analytics.put("accounts7d", this.getCandleChange7d(domain + "_accounts"));
        analytics.put("trans_count", TokenInfo.getCandleLastValue("trans_count"));
        analytics.put("accounts_count", TokenInfo.getCandleLastValue("accounts_count"));
        analytics.put("tokens_count", TokenInfo.getCandleLastValue("tokens_count"));
        analytics.put("trans_count7d", this.getCandleChange7d("trans_count"));
        analytics.put("accounts_count7d", this.getCandleChange7d("accounts_count"));
        analytics.put("tokens_count7d", this.getCandleChange7d("tokens_count"));
        this.response.put("analytics", analytics);
    }
}

