/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.utils;

import com.metabrain.gdb.BigArray;
import com.metabrain.gdb.model.BigArrayCell;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Top<Type extends TopId> {
    private final BigArray<Type> topStorage;
    private final Comparator<Type> comparator;
    private final int maxSize;

    public Top(String fileId, Class<Type> typeClass, Comparator<Type> comparator, int maxSize) {
        this(null, fileId, typeClass, comparator, maxSize);
    }

    public Top(File dir, String fileId, Class<Type> typeClass, Comparator<Type> comparator, int maxSize) {
        this.topStorage = new BigArray<Type>(dir, fileId, typeClass);
        this.comparator = comparator;
        this.maxSize = maxSize;
    }

    public void add(Type item) {
        for (long i = 0L; i < this.topStorage.size(); ++i) {
            TopId existing = (TopId)this.topStorage.get(i);
            if (existing == null || !existing.getId().equals(item.getId())) continue;
            this.topStorage.set(i, item);
            this.sortTop();
            return;
        }
        if (this.topStorage.size() < (long)this.maxSize) {
            this.topStorage.add(item);
        } else {
            TopId last = (TopId)this.topStorage.get(this.topStorage.size() - 1L);
            if (this.comparator.compare(item, last) > 0) {
                this.topStorage.set(this.topStorage.size() - 1L, item);
            } else {
                return;
            }
        }
        this.sortTop();
    }

    public List<Type> getTop() {
        ArrayList<TopId> result = new ArrayList<TopId>();
        for (long i = 0L; i < Math.min(this.topStorage.size(), (long)this.maxSize); ++i) {
            TopId item = (TopId)this.topStorage.get(i);
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }

    private void sortTop() {
        ArrayList<TopId> items = new ArrayList<TopId>();
        for (long i = 0L; i < this.topStorage.size(); ++i) {
            items.add((TopId)this.topStorage.get(i));
        }
        items.sort(this.comparator);
        for (int i = 0; i < items.size(); ++i) {
            this.topStorage.set(i, (TopId)items.get(i));
        }
    }

    public static interface TopId
    extends BigArrayCell {
        public String getId();
    }
}

