/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.ftpserver.ftplet.DataType;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Structure;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.impl.DefaultFtpSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.IODataConnectionFactory;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.apache.ftpserver.listener.Listener;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.ReadFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;
import org.apache.mina.filter.ssl.SslFilter;
import org.slf4j.LoggerFactory;

public class FtpIoSession
implements IoSession {
    public static final String ATTRIBUTE_PREFIX = "org.apache.ftpserver.";
    private static final String ATTRIBUTE_USER_ARGUMENT = "org.apache.ftpserver.user-argument";
    private static final String ATTRIBUTE_SESSION_ID = "org.apache.ftpserver.session-id";
    private static final String ATTRIBUTE_USER = "org.apache.ftpserver.user";
    private static final String ATTRIBUTE_LANGUAGE = "org.apache.ftpserver.language";
    private static final String ATTRIBUTE_LOGIN_TIME = "org.apache.ftpserver.login-time";
    private static final String ATTRIBUTE_DATA_CONNECTION = "org.apache.ftpserver.data-connection";
    private static final String ATTRIBUTE_FILE_SYSTEM = "org.apache.ftpserver.file-system";
    private static final String ATTRIBUTE_RENAME_FROM = "org.apache.ftpserver.rename-from";
    private static final String ATTRIBUTE_FILE_OFFSET = "org.apache.ftpserver.file-offset";
    private static final String ATTRIBUTE_DATA_TYPE = "org.apache.ftpserver.data-type";
    private static final String ATTRIBUTE_STRUCTURE = "org.apache.ftpserver.structure";
    private static final String ATTRIBUTE_FAILED_LOGINS = "org.apache.ftpserver.failed-logins";
    private static final String ATTRIBUTE_LISTENER = "org.apache.ftpserver.listener";
    private static final String ATTRIBUTE_MAX_IDLE_TIME = "org.apache.ftpserver.max-idle-time";
    private static final String ATTRIBUTE_LAST_ACCESS_TIME = "org.apache.ftpserver.last-access-time";
    private static final String ATTRIBUTE_CACHED_REMOTE_ADDRESS = "org.apache.ftpserver.cached-remote-address";
    private final IoSession wrappedSession;
    private final FtpServerContext context;
    private FtpReply lastReply = null;

    @Override
    public CloseFuture close() {
        return this.wrappedSession.close();
    }

    @Override
    public CloseFuture close(boolean immediately) {
        return this.wrappedSession.close(immediately);
    }

    @Override
    public CloseFuture closeNow() {
        return this.wrappedSession.closeNow();
    }

    @Override
    public CloseFuture closeOnFlush() {
        return this.wrappedSession.closeOnFlush();
    }

    @Override
    public boolean containsAttribute(Object key) {
        return this.wrappedSession.containsAttribute(key);
    }

    @Override
    public Object getAttachment() {
        return this.wrappedSession.getAttachment();
    }

    @Override
    public Object getAttribute(Object key) {
        return this.wrappedSession.getAttribute(key);
    }

    @Override
    public Object getAttribute(Object key, Object defaultValue) {
        return this.wrappedSession.getAttribute(key, defaultValue);
    }

    @Override
    public Set<Object> getAttributeKeys() {
        return this.wrappedSession.getAttributeKeys();
    }

    @Override
    public int getBothIdleCount() {
        return this.wrappedSession.getBothIdleCount();
    }

    @Override
    public CloseFuture getCloseFuture() {
        return this.wrappedSession.getCloseFuture();
    }

    @Override
    public IoSessionConfig getConfig() {
        return this.wrappedSession.getConfig();
    }

    @Override
    public long getCreationTime() {
        return this.wrappedSession.getCreationTime();
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.wrappedSession.getFilterChain();
    }

    @Override
    public IoHandler getHandler() {
        return this.wrappedSession.getHandler();
    }

    @Override
    public long getId() {
        return this.wrappedSession.getId();
    }

    @Override
    public int getIdleCount(IdleStatus status) {
        return this.wrappedSession.getIdleCount(status);
    }

    @Override
    public long getLastBothIdleTime() {
        return this.wrappedSession.getLastBothIdleTime();
    }

    @Override
    public long getLastIdleTime(IdleStatus status) {
        return this.wrappedSession.getLastIdleTime(status);
    }

    @Override
    public long getLastIoTime() {
        return this.wrappedSession.getLastIoTime();
    }

    @Override
    public long getLastReadTime() {
        return this.wrappedSession.getLastReadTime();
    }

    @Override
    public long getLastReaderIdleTime() {
        return this.wrappedSession.getLastReaderIdleTime();
    }

    @Override
    public long getLastWriteTime() {
        return this.wrappedSession.getLastWriteTime();
    }

    @Override
    public long getLastWriterIdleTime() {
        return this.wrappedSession.getLastWriterIdleTime();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.wrappedSession.getLocalAddress();
    }

    @Override
    public long getReadBytes() {
        return this.wrappedSession.getReadBytes();
    }

    @Override
    public double getReadBytesThroughput() {
        return this.wrappedSession.getReadBytesThroughput();
    }

    @Override
    public long getReadMessages() {
        return this.wrappedSession.getReadMessages();
    }

    @Override
    public double getReadMessagesThroughput() {
        return this.wrappedSession.getReadMessagesThroughput();
    }

    @Override
    public int getReaderIdleCount() {
        return this.wrappedSession.getReaderIdleCount();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        SocketAddress address = this.wrappedSession.getRemoteAddress();
        if (address == null && this.containsAttribute(ATTRIBUTE_CACHED_REMOTE_ADDRESS)) {
            return (SocketAddress)this.getAttribute(ATTRIBUTE_CACHED_REMOTE_ADDRESS);
        }
        this.setAttribute(ATTRIBUTE_CACHED_REMOTE_ADDRESS, address);
        return address;
    }

    @Override
    public long getScheduledWriteBytes() {
        return this.wrappedSession.getScheduledWriteBytes();
    }

    @Override
    public int getScheduledWriteMessages() {
        return this.wrappedSession.getScheduledWriteMessages();
    }

    @Override
    public IoService getService() {
        return this.wrappedSession.getService();
    }

    @Override
    public SocketAddress getServiceAddress() {
        return this.wrappedSession.getServiceAddress();
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return this.wrappedSession.getTransportMetadata();
    }

    @Override
    public int getWriterIdleCount() {
        return this.wrappedSession.getWriterIdleCount();
    }

    @Override
    public long getWrittenBytes() {
        return this.wrappedSession.getWrittenBytes();
    }

    @Override
    public double getWrittenBytesThroughput() {
        return this.wrappedSession.getWrittenBytesThroughput();
    }

    @Override
    public long getWrittenMessages() {
        return this.wrappedSession.getWrittenMessages();
    }

    @Override
    public double getWrittenMessagesThroughput() {
        return this.wrappedSession.getWrittenMessagesThroughput();
    }

    @Override
    public boolean isClosing() {
        return this.wrappedSession.isClosing();
    }

    @Override
    public boolean isConnected() {
        return this.wrappedSession.isConnected();
    }

    @Override
    public boolean isActive() {
        return this.wrappedSession.isActive();
    }

    @Override
    public boolean isIdle(IdleStatus status) {
        return this.wrappedSession.isIdle(status);
    }

    @Override
    public ReadFuture read() {
        return this.wrappedSession.read();
    }

    @Override
    public Object removeAttribute(Object key) {
        return this.wrappedSession.removeAttribute(key);
    }

    @Override
    public boolean removeAttribute(Object key, Object value) {
        return this.wrappedSession.removeAttribute(key, value);
    }

    @Override
    public boolean replaceAttribute(Object key, Object oldValue, Object newValue) {
        return this.wrappedSession.replaceAttribute(key, oldValue, newValue);
    }

    @Override
    public void resumeRead() {
        this.wrappedSession.resumeRead();
    }

    @Override
    public void resumeWrite() {
        this.wrappedSession.resumeWrite();
    }

    @Override
    public Object setAttachment(Object attachment) {
        return this.wrappedSession.setAttachment(attachment);
    }

    @Override
    public Object setAttribute(Object key) {
        return this.wrappedSession.setAttribute(key);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.wrappedSession.setAttribute(key, value);
    }

    @Override
    public Object setAttributeIfAbsent(Object key) {
        return this.wrappedSession.setAttributeIfAbsent(key);
    }

    @Override
    public Object setAttributeIfAbsent(Object key, Object value) {
        return this.wrappedSession.setAttributeIfAbsent(key, value);
    }

    @Override
    public void suspendRead() {
        this.wrappedSession.suspendRead();
    }

    @Override
    public void suspendWrite() {
        this.wrappedSession.suspendWrite();
    }

    @Override
    public WriteFuture write(Object message) {
        WriteFuture future = this.wrappedSession.write(message);
        this.lastReply = (FtpReply)message;
        return future;
    }

    @Override
    public WriteFuture write(Object message, SocketAddress destination) {
        WriteFuture future = this.wrappedSession.write(message, destination);
        this.lastReply = (FtpReply)message;
        return future;
    }

    public void resetState() {
        this.removeAttribute(ATTRIBUTE_RENAME_FROM);
        this.removeAttribute(ATTRIBUTE_FILE_OFFSET);
    }

    public synchronized ServerDataConnectionFactory getDataConnection() {
        if (this.containsAttribute(ATTRIBUTE_DATA_CONNECTION)) {
            return (ServerDataConnectionFactory)this.getAttribute(ATTRIBUTE_DATA_CONNECTION);
        }
        IODataConnectionFactory dataCon = new IODataConnectionFactory(this.context, this);
        dataCon.setServerControlAddress(((InetSocketAddress)this.getLocalAddress()).getAddress());
        this.setAttribute(ATTRIBUTE_DATA_CONNECTION, dataCon);
        return dataCon;
    }

    public FileSystemView getFileSystemView() {
        return (FileSystemView)this.getAttribute(ATTRIBUTE_FILE_SYSTEM);
    }

    public User getUser() {
        return (User)this.getAttribute(ATTRIBUTE_USER);
    }

    public boolean isLoggedIn() {
        return this.containsAttribute(ATTRIBUTE_USER);
    }

    public Listener getListener() {
        return (Listener)this.getAttribute(ATTRIBUTE_LISTENER);
    }

    public void setListener(Listener listener) {
        this.setAttribute(ATTRIBUTE_LISTENER, listener);
    }

    public FtpSession getFtpletSession() {
        return new DefaultFtpSession(this);
    }

    public String getLanguage() {
        return (String)this.getAttribute(ATTRIBUTE_LANGUAGE);
    }

    public void setLanguage(String language) {
        this.setAttribute(ATTRIBUTE_LANGUAGE, language);
    }

    public String getUserArgument() {
        return (String)this.getAttribute(ATTRIBUTE_USER_ARGUMENT);
    }

    public void setUser(User user) {
        this.setAttribute(ATTRIBUTE_USER, user);
    }

    public void setUserArgument(String userArgument) {
        this.setAttribute(ATTRIBUTE_USER_ARGUMENT, userArgument);
    }

    public int getMaxIdleTime() {
        return (Integer)this.getAttribute(ATTRIBUTE_MAX_IDLE_TIME, 0);
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.setAttribute(ATTRIBUTE_MAX_IDLE_TIME, maxIdleTime);
        int listenerTimeout = this.getListener().getIdleTimeout();
        if (listenerTimeout <= 0 || maxIdleTime > 0 && maxIdleTime < listenerTimeout) {
            this.wrappedSession.getConfig().setBothIdleTime(maxIdleTime);
        }
    }

    public synchronized void increaseFailedLogins() {
        int failedLogins = (Integer)this.getAttribute(ATTRIBUTE_FAILED_LOGINS, 0);
        this.setAttribute(ATTRIBUTE_FAILED_LOGINS, ++failedLogins);
    }

    public int getFailedLogins() {
        return (Integer)this.getAttribute(ATTRIBUTE_FAILED_LOGINS, 0);
    }

    public void setLogin(FileSystemView fsview) {
        this.setAttribute(ATTRIBUTE_LOGIN_TIME, new Date());
        this.setAttribute(ATTRIBUTE_FILE_SYSTEM, fsview);
    }

    public void reinitialize() {
        this.logoutUser();
        this.removeAttribute(ATTRIBUTE_USER);
        this.removeAttribute(ATTRIBUTE_USER_ARGUMENT);
        this.removeAttribute(ATTRIBUTE_LOGIN_TIME);
        this.removeAttribute(ATTRIBUTE_FILE_SYSTEM);
        this.removeAttribute(ATTRIBUTE_RENAME_FROM);
        this.removeAttribute(ATTRIBUTE_FILE_OFFSET);
    }

    public void logoutUser() {
        ServerFtpStatistics stats = (ServerFtpStatistics)this.context.getFtpStatistics();
        if (stats != null) {
            stats.setLogout(this);
            LoggerFactory.getLogger(this.getClass()).debug("Statistics login decreased due to user logout");
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("Statistics not available in session, can not decrease login  count");
        }
    }

    public void setFileOffset(long fileOffset) {
        this.setAttribute(ATTRIBUTE_FILE_OFFSET, fileOffset);
    }

    public void setRenameFrom(FtpFile renFr) {
        this.setAttribute(ATTRIBUTE_RENAME_FROM, renFr);
    }

    public FtpFile getRenameFrom() {
        return (FtpFile)this.getAttribute(ATTRIBUTE_RENAME_FROM);
    }

    public long getFileOffset() {
        return (Long)this.getAttribute(ATTRIBUTE_FILE_OFFSET, 0L);
    }

    public void setStructure(Structure structure) {
        this.setAttribute(ATTRIBUTE_STRUCTURE, (Object)structure);
    }

    public void setDataType(DataType dataType) {
        this.setAttribute(ATTRIBUTE_DATA_TYPE, (Object)dataType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getSessionId() {
        IoSession ioSession = this.wrappedSession;
        synchronized (ioSession) {
            if (!this.wrappedSession.containsAttribute(ATTRIBUTE_SESSION_ID)) {
                this.wrappedSession.setAttribute(ATTRIBUTE_SESSION_ID, UUID.randomUUID());
            }
            return (UUID)this.wrappedSession.getAttribute(ATTRIBUTE_SESSION_ID);
        }
    }

    public FtpIoSession(IoSession wrappedSession, FtpServerContext context) {
        this.wrappedSession = wrappedSession;
        this.context = context;
    }

    public Structure getStructure() {
        return (Structure)((Object)this.getAttribute(ATTRIBUTE_STRUCTURE, (Object)Structure.FILE));
    }

    public DataType getDataType() {
        return (DataType)((Object)this.getAttribute(ATTRIBUTE_DATA_TYPE, (Object)DataType.ASCII));
    }

    public Date getLoginTime() {
        return (Date)this.getAttribute(ATTRIBUTE_LOGIN_TIME);
    }

    public Date getLastAccessTime() {
        return (Date)this.getAttribute(ATTRIBUTE_LAST_ACCESS_TIME);
    }

    public Certificate[] getClientCertificates() {
        SslFilter sslFilter;
        SSLSession sslSession;
        if (this.getFilterChain().contains(SslFilter.class) && (sslSession = (sslFilter = (SslFilter)this.getFilterChain().get(SslFilter.class)).getSslSession(this)) != null) {
            try {
                return sslSession.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return null;
    }

    public void updateLastAccessTime() {
        this.setAttribute(ATTRIBUTE_LAST_ACCESS_TIME, new Date());
    }

    @Override
    public Object getCurrentWriteMessage() {
        return this.wrappedSession.getCurrentWriteMessage();
    }

    @Override
    public WriteRequest getCurrentWriteRequest() {
        return this.wrappedSession.getCurrentWriteRequest();
    }

    @Override
    public boolean isBothIdle() {
        return this.wrappedSession.isBothIdle();
    }

    @Override
    public boolean isReaderIdle() {
        return this.wrappedSession.isReaderIdle();
    }

    @Override
    public boolean isWriterIdle() {
        return this.wrappedSession.isWriterIdle();
    }

    public boolean isSecure() {
        return this.getFilterChain().contains(SslFilter.class);
    }

    public void increaseWrittenDataBytes(int increment) {
        if (this.wrappedSession instanceof AbstractIoSession) {
            ((AbstractIoSession)this.wrappedSession).increaseScheduledWriteBytes(increment);
            ((AbstractIoSession)this.wrappedSession).increaseWrittenBytes(increment, System.currentTimeMillis());
        }
    }

    public void increaseReadDataBytes(int increment) {
        if (this.wrappedSession instanceof AbstractIoSession) {
            ((AbstractIoSession)this.wrappedSession).increaseReadBytes(increment, System.currentTimeMillis());
        }
    }

    public FtpReply getLastReply() {
        return this.lastReply;
    }

    @Override
    public WriteRequestQueue getWriteRequestQueue() {
        return this.wrappedSession.getWriteRequestQueue();
    }

    @Override
    public boolean isReadSuspended() {
        return this.wrappedSession.isReadSuspended();
    }

    @Override
    public boolean isWriteSuspended() {
        return this.wrappedSession.isWriteSuspended();
    }

    @Override
    public void setCurrentWriteRequest(WriteRequest currentWriteRequest) {
        this.wrappedSession.setCurrentWriteRequest(currentWriteRequest);
    }

    @Override
    public void updateThroughput(long currentTime, boolean force) {
        this.wrappedSession.updateThroughput(currentTime, force);
    }

    @Override
    public boolean isSecured() {
        return this.getFilterChain().contains(SslFilter.class);
    }
}

