/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.ssl.impl;

import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.ssl.impl.AliasKeyManager;
import org.apache.ftpserver.ssl.impl.ExtendedAliasKeyManager;
import org.apache.ftpserver.util.ClassUtils;

public class DefaultSslConfiguration
implements SslConfiguration {
    private final KeyManagerFactory keyManagerFactory;
    private final TrustManagerFactory trustManagerFactory;
    private String[] enabledProtocols = new String[]{"TLSv1.2"};
    private final ClientAuth clientAuth;
    private final String keyAlias;
    private final String[] enabledCipherSuites;
    private final SSLContext sslContext;
    private final SSLSocketFactory socketFactory;

    public DefaultSslConfiguration(KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory, ClientAuth clientAuthReqd, String[] sslProtocols, String[] enabledCipherSuites, String keyAlias) throws GeneralSecurityException {
        this.clientAuth = clientAuthReqd;
        this.enabledCipherSuites = enabledCipherSuites;
        this.keyAlias = keyAlias;
        this.keyManagerFactory = keyManagerFactory;
        this.enabledProtocols = sslProtocols;
        this.trustManagerFactory = trustManagerFactory;
        this.sslContext = this.initContext();
        this.socketFactory = this.sslContext.getSocketFactory();
    }

    public DefaultSslConfiguration(KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory, ClientAuth clientAuthReqd, String sslProtocol, String[] enabledCipherSuites, String keyAlias) throws GeneralSecurityException {
        this.clientAuth = clientAuthReqd;
        this.enabledCipherSuites = enabledCipherSuites;
        this.keyAlias = keyAlias;
        this.keyManagerFactory = keyManagerFactory;
        this.enabledProtocols = new String[]{sslProtocol};
        this.trustManagerFactory = trustManagerFactory;
        this.sslContext = this.initContext();
        this.socketFactory = this.sslContext.getSocketFactory();
    }

    @Override
    public SSLSocketFactory getSocketFactory() throws GeneralSecurityException {
        return this.socketFactory;
    }

    @Override
    public SSLContext getSSLContext(String enabledProtocol) throws GeneralSecurityException {
        return this.sslContext;
    }

    public String getEnabledProtoco() {
        if (this.enabledProtocols != null && this.enabledProtocols.length > 0) {
            return this.enabledProtocols[0];
        }
        return "TLSv1.2";
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    @Override
    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    @Override
    public SSLContext getSSLContext() throws GeneralSecurityException {
        return this.getSSLContext(this.enabledProtocols[0]);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        if (this.enabledCipherSuites != null) {
            return (String[])this.enabledCipherSuites.clone();
        }
        return null;
    }

    private SSLContext initContext() throws GeneralSecurityException {
        KeyManager[] keyManagers = this.keyManagerFactory.getKeyManagers();
        for (int i = 0; i < keyManagers.length; ++i) {
            if (ClassUtils.extendsClass(keyManagers[i].getClass(), "javax.net.ssl.X509ExtendedKeyManager")) {
                keyManagers[i] = new ExtendedAliasKeyManager(keyManagers[i], this.keyAlias);
                continue;
            }
            if (!(keyManagers[i] instanceof X509KeyManager)) continue;
            keyManagers[i] = new AliasKeyManager(keyManagers[i], this.keyAlias);
        }
        SSLContext ctx = SSLContext.getInstance(this.enabledProtocols[0]);
        ctx.init(keyManagers, this.trustManagerFactory.getTrustManagers(), null);
        return ctx;
    }
}

