/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import org.bson.Document;
import org.eclipse.jetty.nosql.mongodb.MongoSessionDataStore;
import org.eclipse.jetty.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.session.SessionDataStore;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.StringUtil;

public class MongoSessionDataStoreFactory
extends AbstractSessionDataStoreFactory {
    String _dbName;
    String _collectionName;
    String _host;
    String _connectionString;
    int _port = -1;

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public String getDbName() {
        return this._dbName;
    }

    public void setDbName(String dbName) {
        this._dbName = dbName;
    }

    public String getConnectionString() {
        return this._connectionString;
    }

    public void setConnectionString(String connectionString) {
        this._connectionString = connectionString;
    }

    public String getCollectionName() {
        return this._collectionName;
    }

    public void setCollectionName(String collectionName) {
        this._collectionName = collectionName;
    }

    @Override
    public SessionDataStore getSessionDataStore(SessionManager sessionManager) throws Exception {
        MongoSessionDataStore store = new MongoSessionDataStore();
        store.setGracePeriodSec(this.getGracePeriodSec());
        store.setSavePeriodSec(this.getSavePeriodSec());
        MongoClient mongo = !StringUtil.isBlank(this.getConnectionString()) ? MongoClients.create((String)this.getConnectionString()) : (!StringUtil.isBlank(this.getHost()) && this.getPort() != -1 ? MongoClients.create((String)("mongodb://" + this.getHost() + ":" + this.getPort())) : (!StringUtil.isBlank(this.getHost()) ? MongoClients.create((String)("mongodb://" + this.getHost())) : MongoClients.create()));
        store.setDBCollection((MongoCollection<Document>)mongo.getDatabase(this.getDbName()).getCollection(this.getCollectionName()));
        return store;
    }
}

