/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.rewrite.handler.Rule;

public class ForceRequestHeaderValueRule
extends Rule {
    private String headerName;
    private String headerValue;

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderValue(String headerValue) {
        this.headerValue = headerValue;
    }

    @Override
    public Rule.Handler matchAndApply(Rule.Handler input) throws IOException {
        HttpFields headers = input.getHeaders();
        String existingValue = headers.get(this.headerName);
        if (existingValue == null) {
            return null;
        }
        if (existingValue.equals(this.headerValue)) {
            return null;
        }
        final HttpFields.Mutable newHeaders = HttpFields.build(headers);
        newHeaders.remove(this.headerName);
        newHeaders.add(this.headerName, this.headerValue);
        return new Rule.Handler(this, input){
            final /* synthetic */ ForceRequestHeaderValueRule this$0;
            {
                this.this$0 = this$0;
                super(handler);
            }

            @Override
            public HttpFields getHeaders() {
                return newHeaders;
            }
        };
    }
}

