/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.rewrite.handler.Rule;

public abstract class PatternRule
extends Rule {
    private String _pattern;

    protected PatternRule() {
    }

    protected PatternRule(String pattern) {
        this._pattern = pattern;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    @Override
    public Rule.Handler matchAndApply(Rule.Handler input) throws IOException {
        if (ServletPathSpec.match(this._pattern, input.getHttpURI().getPath())) {
            return this.apply(input);
        }
        return null;
    }

    protected abstract Rule.Handler apply(Rule.Handler var1) throws IOException;

    @Override
    public String toString() {
        return "%s[pattern=%s]".formatted(super.toString(), this.getPattern());
    }
}

