/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class ResponseStatusHeaderRegexRule
extends Rule {
    private String _headerName;
    private Pattern _headerRegex;
    private int _code;
    private String _message;

    @Override
    public boolean isTerminating() {
        return true;
    }

    public String getHeaderName() {
        return this._headerName;
    }

    public void setHeaderName(String headerName) {
        this._headerName = headerName;
    }

    public String getHeaderRegex() {
        return this._headerRegex == null ? null : this._headerRegex.pattern();
    }

    public void setHeaderRegex(String headerRegex) {
        this._headerRegex = headerRegex == null ? null : Pattern.compile(headerRegex);
    }

    public int getCode() {
        return this._code;
    }

    public void setCode(int code) {
        if (code < 100) {
            throw new IllegalArgumentException("invalid http status code");
        }
        this._code = code;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    @Override
    public Rule.Handler matchAndApply(Rule.Handler input) throws IOException {
        String value = input.getHeaders().get(this.getHeaderName());
        if (value == null) {
            return null;
        }
        if (this._headerRegex == null) {
            return this.apply(input, value);
        }
        Matcher matcher = this._headerRegex.matcher(value);
        if (matcher.matches()) {
            return this.apply(input, value);
        }
        return null;
    }

    public Rule.Handler apply(Rule.Handler input, String value) throws IOException {
        return new Rule.Handler(input){

            @Override
            protected boolean handle(Response response, Callback callback) {
                Response.writeError(this, response, callback, ResponseStatusHeaderRegexRule.this._code, ResponseStatusHeaderRegexRule.this._message);
                return true;
            }
        };
    }

    @Override
    public String toString() {
        return "%s[header:%s=%s][response:%d>%s]".formatted(super.toString(), this.getHeaderName(), this.getHeaderRegex(), this.getCode(), this.getMessage());
    }
}

