/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleContainer
extends Rule
implements Iterable<Rule>,
Dumpable {
    public static final String ORIGINAL_QUERYSTRING_ATTRIBUTE_SUFFIX = ".QUERYSTRING";
    private static final Logger LOG = LoggerFactory.getLogger(RuleContainer.class);
    private final List<Rule> _rules = new ArrayList<Rule>();
    private String _originalPathAttribute;
    private String _originalQueryStringAttribute;

    public List<Rule> getRules() {
        return List.copyOf(this._rules);
    }

    public void setRules(List<Rule> rules) {
        this.clear();
        this._rules.addAll(rules);
    }

    @Override
    public Iterator<Rule> iterator() {
        return this._rules.iterator();
    }

    public void addRule(Rule rule) {
        this._rules.add(rule);
    }

    public void clear() {
        this._rules.clear();
    }

    public String getOriginalPathAttribute() {
        return this._originalPathAttribute;
    }

    public void setOriginalPathAttribute(String originalPathAttribute) {
        this._originalPathAttribute = originalPathAttribute;
        this._originalQueryStringAttribute = originalPathAttribute + ORIGINAL_QUERYSTRING_ATTRIBUTE_SUFFIX;
    }

    @Override
    public Rule.Handler matchAndApply(Rule.Handler input) throws IOException {
        String originalPathAttribute = this.getOriginalPathAttribute();
        if (originalPathAttribute != null) {
            HttpURI httpURI = input.getHttpURI();
            input.setAttribute(originalPathAttribute, httpURI.getPath());
            String originalQueryStringAttribute = this._originalQueryStringAttribute;
            if (originalQueryStringAttribute != null) {
                input.setAttribute(originalQueryStringAttribute, httpURI.getQuery());
            }
        }
        boolean match = false;
        for (Rule rule : this._rules) {
            Rule.Handler output;
            if (LOG.isDebugEnabled()) {
                LOG.debug("applying {}", (Object)rule);
            }
            if ((output = rule.matchAndApply(input)) == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("no match {}", (Object)rule);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("match {}", (Object)rule);
            }
            match = true;
            input = output;
            if (!rule.isTerminating()) continue;
            if (!LOG.isDebugEnabled()) break;
            LOG.debug("terminating {}", (Object)rule);
            break;
        }
        return match ? input : null;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this._rules);
    }
}

