/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.security.openid.OpenIdLoginService;

public class OpenIdAuthenticatorConfiguration
extends Authenticator.Configuration.Wrapper {
    private final OpenIdLoginService _openIdLoginService;

    public OpenIdAuthenticatorConfiguration(OpenIdConfiguration openIdConfiguration, Authenticator.Configuration authenticatorConfiguration) {
        super(authenticatorConfiguration);
        LoginService loginService = authenticatorConfiguration.getLoginService();
        if (loginService instanceof OpenIdLoginService) {
            this._openIdLoginService = (OpenIdLoginService)loginService;
        } else {
            this._openIdLoginService = new OpenIdLoginService(openIdConfiguration, loginService);
            if (loginService == null) {
                this._openIdLoginService.setIdentityService(authenticatorConfiguration.getIdentityService());
            }
        }
    }

    @Override
    public LoginService getLoginService() {
        return this._openIdLoginService;
    }
}

