/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.util.Collection;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.openid.OpenIdAuthenticator;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.security.openid.OpenIdLoginService;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Server;

public class OpenIdAuthenticatorFactory
implements Authenticator.Factory {
    @Override
    public Authenticator getAuthenticator(Server server, Context context, Authenticator.Configuration configuration) {
        LoginService loginService = configuration.getLoginService();
        String auth = configuration.getAuthenticationType();
        if ("OPENID".equalsIgnoreCase(auth)) {
            if (loginService instanceof OpenIdLoginService) {
                return new OpenIdAuthenticator(((OpenIdLoginService)loginService).getConfiguration());
            }
            Collection<OpenIdConfiguration> configurations = server.getBeans(OpenIdConfiguration.class);
            if (configurations == null || configurations.isEmpty()) {
                throw new IllegalStateException("No OpenIdConfiguration found");
            }
            if (configurations.size() == 1) {
                return new OpenIdAuthenticator(configurations.iterator().next());
            }
            String realmName = configuration.getRealmName();
            OpenIdConfiguration openIdConfiguration = configurations.stream().filter(c -> c.getIssuer().equals(realmName)).findAny().orElseThrow(() -> new IllegalStateException("No OpenIdConfiguration found for realm \"" + realmName + "\""));
            return new OpenIdAuthenticator(openIdConfiguration);
        }
        return null;
    }
}

