/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.exchange;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.vavilon.servers.WssServer;
import net.vavilon.token.Send;
import net.vavilon.utils.InfiniteTimer;
import net.vavilon.utils.Request;
import org.exchange.Exchange;
import org.exchange.exchange.CancelAll;
import org.exchange.exchange.ExchangeUtils;
import org.exchange.exchange.Place;

public class Bot
extends ExchangeUtils
implements InfiniteTimer.Callback {
    public static final String BOT_SEED = "exhibit tragic bundle galaxy zero lunch lift six access story round ";
    public static Map<String, Bot> bots = new HashMap<String, Bot>();
    public static final Map<String, String> botAddressToDomain = new HashMap<String, String>();
    public String bot_password;
    public String bot_address;
    private String domain;
    private final InfiniteTimer secTimer;

    public Bot(String domain) {
        if (domain.equals("usdt")) {
            Bot.error("gas domain is not available");
        }
        this.domain = domain;
        this.bot_password = Bot.hash(BOT_SEED + domain);
        this.bot_address = Bot.hashAddress(this.bot_password);
        botAddressToDomain.put(this.bot_address, domain);
        if (Send.getAccount(domain, this.bot_address) == null) {
            Send.regAccount("usdt", this.bot_address, this.bot_password);
            Send.regAccount(domain, this.bot_address, this.bot_password);
        } else {
            Bot.incBalance("usdt", this.bot_address, Send.getAccount((String)"usdt", (String)this.bot_address).balance);
            Bot.incBalance(domain, this.bot_address, Send.getAccount((String)domain, (String)this.bot_address).balance);
        }
        this.secTimer = new InfiniteTimer(this, Exchange.FAST_TEST ? Duration.ofMillis(50L).toMillis() : Duration.ofSeconds(1L).toMillis(), Duration.ofDays(30L).toMillis());
    }

    public void refresh() {
        this.secTimer.restart();
    }

    @Override
    public void onTimer() {
        try {
            new CancelAll().run("", Request.map("domain", this.domain, "address", this.bot_address));
            boolean isSell = Bot.random() % 2 == 0;
            double oldPrice = Bot.getPrice(this.domain);
            double tokenBalance = this.getBalance(this.domain, this.bot_address);
            double gasBalance = this.getBalance("usdt", this.bot_address);
            if (oldPrice == 0.0) {
                oldPrice = 1.0;
            }
            double volatility = 0.01;
            double nextPrice = Bot.round(oldPrice * (1.0 + (double)(isSell ? -1 : 1) * volatility));
            double needPrice = gasBalance / tokenBalance;
            double spredInGas = gasBalance / 10.0;
            nextPrice += (needPrice - nextPrice) * 0.1;
            this.fillOrderbook(this.domain, nextPrice, 3.0, spredInGas, 7);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("error: " + e.getMessage());
        }
        WssServer.broadcast("orderbook:" + this.domain, Request.map("x", "1"));
    }

    void fillOrderbook(String domain, double tokenPrice, double rangePercent, double gasAmount, int orderCount) {
        this.placeRange(domain, tokenPrice, rangePercent, gasAmount, orderCount, true);
        this.placeRange(domain, tokenPrice, rangePercent, gasAmount, orderCount, false);
    }

    public List<Double> steps(double price, double percent, int count) {
        ArrayList<Double> result = new ArrayList<Double>();
        double stepDiff = price * percent / 100.0 / (double)count;
        stepDiff = percent > 0.0 ? Math.max(1.0E-4, stepDiff) : Math.min(-1.0E-4, stepDiff);
        for (int i = 0; i < count; ++i) {
            double step = Bot.round(price + stepDiff * (double)i);
            if (step < 1.0E-4) {
                step = 1.0E-4;
            }
            result.add(step);
        }
        return result;
    }

    public void placeRange(String domain, double price, double rangePercent, double gasAmount, int orderCount, boolean isSell) {
        for (Double stepPrice : this.steps(price, (double)(isSell ? 1 : -1) * rangePercent, orderCount)) {
            double stepAmount = Bot.round(gasAmount / (double)orderCount / stepPrice);
            double stepTotal = Bot.round(stepPrice * stepAmount);
            try {
                Place.place(domain, isSell, stepPrice, stepAmount, stepTotal, this.bot_address);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void run() {
    }
}

