/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.exchange;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.vavilon.analytics.AnalyticsUtils;
import net.vavilon.servers.WssServer;
import net.vavilon.token.Send;
import net.vavilon.token.TokenUtils;
import net.vavilon.token.model.Token;
import net.vavilon.utils.Request;
import org.exchange.exchange.Bot;
import org.exchange.exchange.model.Order;
import org.exchange.exchange.model.PriceLevel;

public abstract class ExchangeUtils
extends AnalyticsUtils {
    public static final String LIMIT = "limit";
    public static final String POST_LIMIT = "post_limit";
    public static final Map<String, Double> balances = new HashMap<String, Double>();
    public static final Map<String, List<Order>> waitOrders = new ConcurrentHashMap<String, List<Order>>();
    public static final Map<Long, Order> activeOrders = new ConcurrentHashMap<Long, Order>();
    public static final LinkedList<Order> historyOrders = new LinkedList();
    private final Map<Long, Order> newOrders = new ConcurrentHashMap<Long, Order>();

    public List<Order> getOrders(String domain, int is_sell, double price) {
        ArrayList<Order> result = new ArrayList<Order>();
        for (Order order : activeOrders.values()) {
            if (!order.domain.equals(domain) || order.is_sell != (long)is_sell || order.status != 0L || !(is_sell == 1 ? order.price <= price : order.price >= price)) continue;
            result.add(order);
        }
        result.sort((o1, o2) -> is_sell == 1 ? Double.compare(o1.price, o2.price) : Double.compare(o2.price, o1.price));
        return result;
    }

    protected double getBalance(String domain, String address) {
        Double balance = balances.get(ExchangeUtils.userBalanceName(address, domain));
        if (balance == null) {
            balance = 0.0;
        }
        return balance;
    }

    public void balanceSend(String domain, String from_user, String to_user, Double amount) {
        if (amount < 0.0) {
            ExchangeUtils.error("amount less than 0");
        }
        if (amount - ExchangeUtils.round(amount) != 0.0) {
            ExchangeUtils.error("max amount decimals is 4");
        }
        if (this.getBalance(domain, from_user) < amount) {
            ExchangeUtils.error("from user balance is not enough");
        }
        ExchangeUtils.incBalance(domain, from_user, -amount.doubleValue());
        ExchangeUtils.incBalance(domain, to_user, amount);
    }

    public void orderFillSell(String address, String domain, double price, double amount) {
        String orderbookAddress = domain;
        this.balanceSend(domain, address, domain, amount);
        double total = ExchangeUtils.round(price * amount);
        Order newOrder = new Order(address, domain, 1, price, amount, total);
        double tradeVolume = 0.0;
        double lastTradePrice = 0.0;
        for (Order order : this.getOrders(domain, 0, price)) {
            double amountNotFilled = ExchangeUtils.round(newOrder.amount - newOrder.amount_filled);
            if (amountNotFilled == 0.0) break;
            double orderTotalNotFilled = ExchangeUtils.round(order.total - order.total_filled);
            double orderAmountNotFilled = orderTotalNotFilled / order.price;
            double amountToFill = Math.min(orderAmountNotFilled, amountNotFilled);
            double totalToFill = amountToFill * order.price;
            order.amount_filled = ExchangeUtils.round(order.amount_filled + amountToFill);
            order.total_filled = ExchangeUtils.round(order.total_filled + totalToFill);
            order.status = orderAmountNotFilled == amountToFill ? 1L : 0L;
            this.setOrder(order);
            if (orderAmountNotFilled == amountToFill) {
                double amountFilled = this.getOrder((long)order.order_id).amount_filled;
                this.balanceSend(domain, orderbookAddress, order.address, amountFilled);
            }
            newOrder.amount_filled = ExchangeUtils.round(newOrder.amount_filled + amountToFill);
            newOrder.total_filled = ExchangeUtils.round(newOrder.total_filled + totalToFill);
            lastTradePrice = order.price;
            tradeVolume += totalToFill;
        }
        if (newOrder.amount == newOrder.amount_filled) {
            this.balanceSend("usdt", orderbookAddress, address, newOrder.total_filled);
            newOrder.status = 1L;
        }
        this.setOrder(newOrder);
        this.trackFill(domain, lastTradePrice, tradeVolume);
    }

    public void orderFillBuy(String address, String domain, double price, double total) {
        String orderbookAddress = domain;
        this.balanceSend("usdt", address, orderbookAddress, total);
        double amount = ExchangeUtils.round(total / price);
        Order newOrder = new Order(address, domain, 0, price, amount, total);
        double tradeVolume = 0.0;
        double lastTradePrice = 0.0;
        for (Order order : this.getOrders(domain, 1, price)) {
            double totalNotFilled = ExchangeUtils.round(newOrder.total - newOrder.total_filled);
            if (totalNotFilled == 0.0) break;
            double orderAmountNotFilled = ExchangeUtils.round(order.amount - order.amount_filled);
            double orderTotalNotFilled = orderAmountNotFilled * order.price;
            double totalToFill = Math.min(orderTotalNotFilled, totalNotFilled);
            double amountToFill = totalToFill / order.price;
            order.amount_filled = ExchangeUtils.round(order.amount_filled + amountToFill);
            order.total_filled = ExchangeUtils.round(order.total_filled + totalToFill);
            order.status = orderTotalNotFilled == totalToFill ? 1L : 0L;
            this.setOrder(order);
            if (orderTotalNotFilled == totalToFill) {
                double totalFilled = this.getOrder((long)order.order_id).total_filled;
                this.balanceSend("usdt", orderbookAddress, order.address, totalFilled);
            }
            newOrder.amount_filled = ExchangeUtils.round(newOrder.amount_filled + amountToFill);
            newOrder.total_filled = ExchangeUtils.round(newOrder.total_filled + totalToFill);
            lastTradePrice = order.price;
            tradeVolume += totalToFill;
        }
        if (newOrder.total == newOrder.total_filled) {
            this.balanceSend(domain, orderbookAddress, address, newOrder.amount_filled);
            newOrder.status = 1L;
        }
        this.setOrder(newOrder);
        this.trackFill(domain, lastTradePrice, tradeVolume);
    }

    public void trackFill(String domain, double price, double volume) {
        if (price != 0.0) {
            this.trackAccumulate(domain + "_volume", volume);
            Token token = TokenUtils.getToken(domain);
            token.price = ExchangeUtils.getCandleLastValue(domain + "_price");
            token.price24 = this.getCandleChange24h(domain + "_price");
            token.volume24 = this.getCandleChange24h(domain + "_volume");
            TokenUtils.tokensByDomain.put(domain, token);
            double lastPrice = ExchangeUtils.getCandleLastValue(domain + "_price");
            if (price != lastPrice) {
                this.trackLinear(domain + "_price", price);
                WssServer.broadcast("price:" + domain, Request.map("price", "" + price));
                WssServer.broadcast("price", Request.map("domain", domain, "price", "" + price, "price24", "" + token.price24));
            }
        }
    }

    public static double getPrice(String domain) {
        return ExchangeUtils.getCandleLastValue(domain + "_price");
    }

    public static double getVolume(String domain) {
        return ExchangeUtils.getCandleLastValue(domain + "_volume");
    }

    public void cancel(long orderId) {
        double totalToGet;
        double amountToGet;
        Order order = this.getOrder(orderId);
        if (order.status != 0L) {
            activeOrders.remove(orderId);
            ExchangeUtils.error("order already finished");
        }
        String orderbookAddress = order.domain;
        if (order.is_sell == 1L) {
            amountToGet = ExchangeUtils.round(order.amount - order.amount_filled);
            totalToGet = ExchangeUtils.round(order.total_filled);
            order.status = totalToGet > 0.0 ? 1L : -1L;
        } else {
            if (order.total == 3.12) {
                System.out.println();
            }
            totalToGet = ExchangeUtils.round(order.total - order.total_filled);
            amountToGet = ExchangeUtils.round(order.amount_filled);
            long l = order.status = amountToGet > 0.0 ? 1L : -1L;
        }
        if (totalToGet > 0.0) {
            this.balanceSend("usdt", orderbookAddress, order.address, totalToGet);
        }
        if (amountToGet > 0.0) {
            this.balanceSend(order.domain, orderbookAddress, order.address, amountToGet);
        }
        this.setOrder(order);
    }

    public void cancelAll(String domain, String address) {
        List<Order> orders = this.ordersActive(domain, address);
        for (Order order : orders) {
            try {
                this.cancel(order.order_id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<Order> ordersActive(String domain, String address) {
        ArrayList<Order> result = new ArrayList<Order>();
        for (Order order : activeOrders.values()) {
            if (!order.domain.equals(domain) || !order.address.equals(address)) continue;
            result.add(new Order(order));
        }
        result.sort((o1, o2) -> Long.compare(o2.timestamp, o1.timestamp));
        return result;
    }

    public static List<Order> ordersHistory(String domain, String username) {
        ArrayList<Order> result = new ArrayList<Order>();
        for (Order order : historyOrders) {
            if (!order.address.equals(username) || !order.domain.equals(domain)) continue;
            result.add(order);
        }
        Collections.reverse(result);
        return result;
    }

    public List<PriceLevel> getPriceLevels(String domain, boolean isSell, int count) {
        HashMap<Double, PriceLevel> levels = new HashMap<Double, PriceLevel>();
        for (Order order : activeOrders.values()) {
            if (!order.domain.equals(domain) || order.is_sell != (long)(isSell ? 1 : 0) || order.status != 0L) continue;
            if (levels.containsKey(order.price)) {
                PriceLevel level = (PriceLevel)levels.get(order.price);
                level.amount += order.amount - order.amount_filled;
                continue;
            }
            levels.put(order.price, new PriceLevel(order.price, order.amount - order.amount_filled));
        }
        ArrayList<PriceLevel> levelsList = new ArrayList<PriceLevel>(levels.values());
        levelsList.sort((o1, o2) -> isSell ? Double.compare(o1.price, o2.price) : Double.compare(o2.price, o1.price));
        return levelsList.size() > count ? levelsList.subList(0, count) : levelsList;
    }

    private Order getOrder(long orderId) {
        Order order = this.newOrders.get(orderId);
        if (order == null && (order = activeOrders.get(orderId)) != null) {
            order = new Order(order);
        }
        return order;
    }

    void setOrder(Order order) {
        this.newOrders.put(order.order_id, order);
    }

    public static String userBalanceName(String domain, String username) {
        return username + ":" + domain;
    }

    public static void incBalance(String domain, String address, Double amount) {
        String userBalanceName = ExchangeUtils.userBalanceName(address, domain);
        Double balance = balances.get(userBalanceName);
        if (balance == null) {
            balance = 0.0;
        }
        if (amount < 0.0 && balance < amount) {
            ExchangeUtils.error("not enough balance");
        }
        balance = ExchangeUtils.round(balance + amount);
        balances.put(userBalanceName, balance);
    }

    @Override
    public void commit() {
        this.commitOrders();
        super.commit();
    }

    private void commitOrders() {
        if (this.newOrders.size() > 0) {
            for (Order order : this.newOrders.values()) {
                if (order.status == 1L || order.status == -1L) {
                    String bot_password = Bot.bots.get((Object)order.domain).bot_password;
                    String bot_address = Bot.bots.get((Object)order.domain).bot_address;
                    if (Bot.bots.get(order.address) == null && Bot.botAddressToDomain.get(order.address) == null) {
                        double amountToGet = 0.0;
                        double totalToGet = 0.0;
                        if (order.is_sell == 1L) {
                            amountToGet = ExchangeUtils.round(order.amount - order.amount_filled);
                            totalToGet = ExchangeUtils.round(order.total_filled);
                        } else if (order.is_sell == 0L) {
                            totalToGet = ExchangeUtils.round(order.total - order.total_filled);
                            amountToGet = ExchangeUtils.round(order.amount_filled);
                        }
                        if (totalToGet > 0.0) {
                            Send.send("usdt", bot_address, order.address, totalToGet, Send.tokenPass("usdt", bot_address, bot_password), null);
                        }
                        if (amountToGet > 0.0) {
                            Send.send(order.domain, bot_address, order.address, amountToGet, Send.tokenPass(order.domain, bot_address, bot_password), null);
                        }
                        historyOrders.add(order);
                        if (historyOrders.size() > 100) {
                            historyOrders.removeFirst();
                        }
                    }
                    activeOrders.remove(order.order_id);
                    continue;
                }
                activeOrders.put(order.order_id, order);
            }
        }
        this.newOrders.clear();
    }
}

