/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.exchange;

import java.util.List;
import org.exchange.exchange.Bot;
import org.exchange.exchange.Orders;
import org.exchange.exchange.model.PriceLevel;

public class OrderBook
extends Orders {
    public static void fillAdditionalData(List<PriceLevel> levels) {
        double sum = 0.0;
        for (PriceLevel level : levels) {
            sum += level.amount;
        }
        double accumulateAmount = 0.0;
        for (PriceLevel level : levels) {
            level.price = OrderBook.round(level.price);
            level.amount = OrderBook.round(level.amount);
            level.percent = OrderBook.round((accumulateAmount += level.amount) / sum * 100.0);
        }
    }

    @Override
    public void run() {
        String domain = this.getRequired("domain");
        List<PriceLevel> sellLevels = this.getPriceLevels(domain, true, 6);
        List<PriceLevel> buyLevels = this.getPriceLevels(domain, false, 6);
        OrderBook.fillAdditionalData(sellLevels);
        OrderBook.fillAdditionalData(buyLevels);
        this.response.put("sell", sellLevels);
        this.response.put("buy", buyLevels);
        Bot.bots.computeIfAbsent(domain, domain2 -> new Bot((String)domain2)).refresh();
    }
}

