/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.exchange;

import java.util.ArrayList;
import net.vavilon.servers.WssServer;
import net.vavilon.utils.Request;
import org.exchange.exchange.Bot;
import org.exchange.exchange.ExchangeUtils;
import org.exchange.exchange.model.Order;

public class Place
extends ExchangeUtils {
    public static void place(String domain, boolean isSell, double price, double amount, double total, String address) {
        new Place().run("", Request.map("domain", domain, "is_sell", "" + (isSell ? 1 : 0), "price", "" + price, "amount", "" + amount, "total", "" + total, "address", address));
    }

    @Override
    public void run() {
        String orderType = this.getString("order_type", "limit");
        String domain = this.getRequired("domain");
        Long is_sell = this.getLongRequired("is_sell");
        double price = this.getDoubleRequired("price");
        double amount = this.getDoubleRequired("amount");
        double total = this.getDoubleRequired("total");
        String address = this.getRequired("address");
        if (price != Place.round(price)) {
            Place.error("max price decimals is 4");
        }
        if (price <= 0.0) {
            Place.error("price less than 0");
        }
        if (amount != Place.round(amount)) {
            Place.error("max amount decimals is 4");
        }
        if (amount <= 0.0) {
            Place.error("amount less than 0");
        }
        if (orderType.equals("post_limit")) {
            waitOrders.computeIfAbsent(address, k -> new ArrayList()).add(new Order("limit", address, domain, is_sell, price, amount, total, this.time()));
        } else if (orderType.equals("limit")) {
            if (is_sell == 1L) {
                this.orderFillSell(address, domain, price, amount);
            } else {
                this.orderFillBuy(address, domain, price, total);
            }
            if (Place.isNotEmpty(this.scriptPath)) {
                WssServer.broadcast("orderbook:" + domain, Request.map("x", "1"));
            }
        }
        this.response.put("deposit_address", Bot.bots.get((Object)domain).bot_address);
    }
}

