/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.miner;

import java.math.BigInteger;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import net.vavilon.Node;
import net.vavilon.contract.MiningInfo;
import net.vavilon.contract.Mint;
import net.vavilon.contract.Mint10;
import net.vavilon.contract.Mint100;
import net.vavilon.contract.Mint20;
import net.vavilon.token.Send;
import net.vavilon.token.TokenUtils;
import net.vavilon.utils.InfiniteTimer;
import net.vavilon.utils.Request;
import net.vavilon.utils.Utils;
import org.exchange.miner.MinerUtils;
import org.exchange.miner.model.MinerAccount;
import org.exchange.tests.SimpleMiner;

public class Miner
implements InfiniteTimer.Callback {
    public final Map<String, MinerAccount> accountsByAddress = new HashMap<String, MinerAccount>();
    private InfiniteTimer InfiniteTimer = new InfiniteTimer(this, Duration.ofSeconds(Node.isDebugMode ? 4L : 60L).toMillis());
    boolean isRunning = false;

    public void start() {
        this.InfiniteTimer.restart();
    }

    @Override
    public void onTimer() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        try {
            for (MinerAccount minerAccount : this.accountsByAddress.values()) {
                try {
                    String minerPassword = Utils.hash(MinerUtils.MINER_PASSWORD + minerAccount.userAddress);
                    String minerAddress = Utils.hashAddress(minerPassword);
                    String[] domains = new String[]{};
                    if (Utils.isNotEmpty(minerAccount.domains)) {
                        domains = minerAccount.domains.split(",");
                    }
                    Send.send("usdt", minerAddress, MinerUtils.ENERGY_ADDRESS, Utils.round(minerAccount.tariff * (double)domains.length), Send.tokenPass("usdt", minerAddress, minerPassword), null);
                    for (String domain : domains) {
                        Long nonce = this.calcNonceByTariff(domain, 1.0E-4);
                        if (nonce == null) continue;
                        this.sendToUser(domain, minerAddress, minerPassword, nonce);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isRunning = false;
    }

    public Long calcNonceByTariff(String domain, double tariff) {
        Long difficulty;
        Map<String, Object> miningInfo = new MiningInfo().run("/mfm-contract/mining_info", Request.map("domain", domain));
        String lastHash = miningInfo.get("last_hash") != null ? (String)miningInfo.get("last_hash") : null;
        Long l = difficulty = miningInfo.get("difficulty") != null ? Long.valueOf(Long.parseLong((String)miningInfo.get("difficulty"))) : null;
        if (lastHash == null) {
            lastHash = "";
        }
        if (difficulty == null) {
            difficulty = 1L;
        }
        int i = 0;
        while ((double)i < tariff * 1.0E9) {
            long nonce = (long)(Math.random() * 1.0E9);
            String str = lastHash + domain + nonce;
            String newHash = Utils.hash(str);
            BigInteger hashNumber = new BigInteger(newHash, 16);
            if ((hashNumber = hashNumber.mod(BigInteger.valueOf(difficulty))).equals(BigInteger.ZERO) || Thread.currentThread().isInterrupted()) {
                return nonce;
            }
            ++i;
        }
        return null;
    }

    void sendToUser(String domain, String subMinerAddress, String subMinerPassword, Long nonce) {
        Map<String, Object> miningInfo = new MiningInfo().run("/mfm-contract/mining_info", Request.map("domain", domain, "address", subMinerAddress));
        SimpleMiner.MiningInfoResponse info = Utils.gson.fromJson(Utils.gson.toJson(miningInfo), SimpleMiner.MiningInfoResponse.class);
        if (nonce != null) {
            Mint endpoint = null;
            if (info.bank.delegate.equals("mfm-contract/mint10")) {
                endpoint = new Mint10();
            } else if (info.bank.delegate.equals("mfm-contract/mint20")) {
                endpoint = new Mint20();
            } else if (info.bank.delegate.equals("mfm-contract/mint100")) {
                endpoint = new Mint100();
            }
            if (endpoint != null) {
                endpoint.run(info.bank.delegate, Request.map("domain", domain, "nonce", nonce, "time", "" + Utils.timeSec(), "gas_address", subMinerAddress, "gas_pass", TokenUtils.tokenPass("usdt", subMinerAddress, subMinerPassword, info.gas_account.prev_key)));
            }
        }
    }
}

