/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.miner.model;

import com.metabrain.gdb.model.BigArrayCell;
import com.metabrain.gdb.utils.Bytes;
import java.util.Arrays;
import java.util.HashSet;

public class MinerAccount
implements BigArrayCell {
    public String userAddress;
    public String minerAddress;
    public String domains;
    public Double tariff;

    public MinerAccount() {
    }

    public MinerAccount(String userAddress, String minerAddress, String domains, Double tariff) {
        this.userAddress = userAddress;
        this.minerAddress = minerAddress;
        this.domains = domains;
        this.tariff = tariff;
    }

    @Override
    public byte[] build() {
        Bytes data = new Bytes();
        data.addString64(this.userAddress);
        data.addString64(this.minerAddress);
        data.addString128(this.domains);
        data.addDouble(this.tariff);
        return data.getBytes();
    }

    @Override
    public void parse(Bytes data) {
        this.userAddress = data.readString64();
        this.minerAddress = data.readString64();
        this.domains = data.readString128();
        this.tariff = data.readDouble();
    }

    public boolean toggleDomain(String id) {
        HashSet<String> set = new HashSet<String>(Arrays.asList((this.domains == null ? "" : this.domains).split(",")));
        boolean isAdding = false;
        if (!set.remove(id)) {
            set.add(id);
            isAdding = true;
        }
        set.remove("");
        this.domains = String.join((CharSequence)",", set);
        return isAdding;
    }
}

