/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.p2p;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exchange.p2p.OfferUtils;
import org.exchange.p2p.model.Offer;
import org.exchange.p2p.model.User;

public class Offers
extends OfferUtils {
    @Override
    public void run() {
        String domain = this.getRequired("domain");
        ArrayList<Offer> sell = new ArrayList<Offer>();
        ArrayList<Offer> buy = new ArrayList<Offer>();
        List<String> ordersIds = offersHistory.getLastStringList(domain, 10L);
        for (String orderId : ordersIds) {
            Offer offer = (Offer)offers.get(Long.parseLong(orderId));
            if (offer == null || !offer.status.equals("active") || !(offer.filled + offer.blocked < offer.amount)) continue;
            offer.user = (User)users.get(offer.address);
            if (offer.is_sell == 1L) {
                sell.add(offer);
                continue;
            }
            buy.add(offer);
        }
        Collections.sort(sell, (o1, o2) -> Double.compare(o1.price, o2.price));
        Collections.sort(buy, (o1, o2) -> Double.compare(o2.price, o1.price));
        this.response.put("sell", sell);
        this.response.put("buy", buy);
    }
}

