/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.p2p;

import java.util.ArrayList;
import java.util.List;
import org.exchange.p2p.OfferUtils;
import org.exchange.p2p.model.Offer;
import org.exchange.p2p.model.Order;
import org.exchange.p2p.model.User;

public class Orders
extends OfferUtils {
    @Override
    public void run() {
        String address = this.getRequired("address");
        List<String> orderIds = userOffers.getLastStringList(address, 10L);
        ArrayList<Offer> offers = new ArrayList<Offer>();
        for (String orderId : orderIds) {
            Offer offer = OfferUtils.offers.get(Long.parseLong(orderId));
            if (offer == null) continue;
            offer.user = (User)users.get(offer.address);
            offers.add(offer);
        }
        List<String> orders = userOrders.getLastStringList(address, 10L);
        ArrayList<Order> active = new ArrayList<Order>();
        ArrayList<Order> finish = new ArrayList<Order>();
        ArrayList<Order> cancel = new ArrayList<Order>();
        ArrayList<Order> appeal = new ArrayList<Order>();
        ArrayList<Order> sent = new ArrayList<Order>();
        for (String order_id : orders) {
            Order order = OfferUtils.orders.get(Long.parseLong(order_id));
            order.offer = OfferUtils.offers.get(order.offer_id);
            if (order.status.equals("active")) {
                active.add(order);
                continue;
            }
            if (order.status.equals("filled")) {
                finish.add(order);
                continue;
            }
            if (order.status.equals("cancel")) {
                cancel.add(order);
                continue;
            }
            if (order.status.equals("appeal")) {
                appeal.add(order);
                continue;
            }
            if (!order.status.equals("sent")) continue;
            sent.add(order);
        }
        this.response.put("offers", offers);
        this.response.put("active", active);
        this.response.put("sent", sent);
        this.response.put("finish", finish);
        this.response.put("cancel", cancel);
        this.response.put("appeal", appeal);
    }
}

