/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.telegram;

import com.metabrain.gdb.BigMap;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.vavilon.servers.model.Endpoint;
import net.vavilon.utils.Bip39;
import net.vavilon.utils.Request;
import org.exchange.telegram.model.SubscriptionCheckResponse;
import org.exchange.telegram.model.TelegramUser;
import org.exchange.telegram.model.TgRequest;

public class Hook
extends Endpoint {
    public static final File dir = new File("telegram");
    public static final BigMap<TelegramUser> usersByUserId = new BigMap<TelegramUser>(dir, "usersByUserId", TelegramUser.class);
    public static final BigMap<TelegramUser> usersByAddress = new BigMap<TelegramUser>(dir, "usersByAddress", TelegramUser.class);
    public static final String CHANNEL_USERNAME = "@vavilon_org_news";
    private static final String CHANNEL_URL = "https://t.me/vavilon_org_news";
    public static final String TOKEN = "7839968643:AAEBWhcirOE3bBRxB6-EIEyZfZA_cCRN51I";
    public static final String BOT_URL = "https://api.telegram.org/bot7839968643:AAEBWhcirOE3bBRxB6-EIEyZfZA_cCRN51I";

    @Override
    public void run() {
        String body = this.getRequired("body");
        System.out.println(body);
        TgRequest request = gson.fromJson(body, TgRequest.class);
        if (request.callback_query != null) {
            this.handleCallbackQuery(request.callback_query);
        } else if (request.message != null && request.message.text != null) {
            this.handleMessage(request);
        }
        System.out.println(gson.toJson(this.response));
    }

    private void handleMessage(TgRequest request) {
        String messageText = request.message.text.trim();
        if (messageText.equals("/start")) {
            this.response.put("method", "sendMessage");
            this.response.put("chat_id", request.message.chat.id);
            this.response.put("text", "\u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c! \u0414\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0431\u043e\u0442\u0443 \u043f\u043e\u0434\u043f\u0438\u0448\u0438\u0442\u0435\u0441\u044c \u043d\u0430 \u043d\u0430\u0448 \u043a\u0430\u043d\u0430\u043b.");
            this.response.put("reply_markup", this.startButtons());
            TelegramUser telegramUser = new TelegramUser(request.message.from.id, request.message.from.username, request.message.chat.id, request.message.from.language_code, request.message.from.first_name, request.message.from.last_name);
            usersByUserId.put("" + request.message.from.id, telegramUser);
            String seed = Bip39.getRandomSeed(request.message.chat.id, Bip39.ENG);
            String password = Hook.hash(seed);
            String address = Hook.hashAddress(password);
            usersByAddress.put(address, telegramUser);
        }
    }

    ReplyMarkup startButtons() {
        ReplyMarkup markup = new ReplyMarkup();
        markup.addButton(new TgButton("\u041f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u043a\u0430\u043d\u0430\u043b", CHANNEL_URL, "url"));
        markup.addButton(new TgButton("\u042f \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043b\u0441\u044f", "check_sub", "callback_data"));
        return markup;
    }

    private void handleCallbackQuery(TgRequest.CallbackQuery callback_query) {
        if (callback_query.data.equals("check_sub")) {
            this.response.put("method", "editMessageText");
            this.response.put("chat_id", callback_query.message.chat.id);
            this.response.put("message_id", callback_query.message.message_id);
            Request.post("https://api.telegram.org/bot7839968643:AAEBWhcirOE3bBRxB6-EIEyZfZA_cCRN51I/getChatMember", Request.map("chat_id", CHANNEL_USERNAME, "user_id", callback_query.from.id), responseStr -> {
                SubscriptionCheckResponse response1 = gson.fromJson(responseStr, SubscriptionCheckResponse.class);
                if (response1.isSubscribed()) {
                    this.response.put("text", "\u2705 \u0421\u043f\u0430\u0441\u0438\u0431\u043e \u0437\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443! \u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u043a\u043d\u043e\u043f\u043a\u0443 PLAY \u0434\u043b\u044f \u0432\u0445\u043e\u0434\u0430 \u0432 \u043a\u043e\u0448\u0435\u043b\u0435\u043a.");
                } else {
                    this.response.put("text", "\u274c \u0412\u044b \u0435\u0449\u0435 \u043d\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u044b \u043d\u0430 \u043a\u0430\u043d\u0430\u043b @vavilon_org_news. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0434\u043f\u0438\u0448\u0438\u0442\u0435\u0441\u044c \u0438 \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.");
                    this.response.put("reply_markup", this.startButtons());
                }
            });
        }
    }

    public static void send(TelegramUser user, String domain, Double amount) {
        Request.postAsync("https://api.telegram.org/bot7839968643:AAEBWhcirOE3bBRxB6-EIEyZfZA_cCRN51I/sendMessage", Request.map("chat_id", user.chatId, "text", "\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 " + new BigDecimal(amount).toPlainString() + " " + domain.toUpperCase()));
    }

    class ReplyMarkup {
        List<List<TgButton>> inline_keyboard = new ArrayList<List<TgButton>>();

        ReplyMarkup() {
        }

        void addButton(TgButton button) {
            ArrayList<TgButton> lineButton = new ArrayList<TgButton>();
            lineButton.add(button);
            this.inline_keyboard.add(lineButton);
        }
    }

    class TgButton {
        String text;
        String callback_data;
        String url;

        public TgButton(String text, String data, String type) {
            this.text = text;
            if (type.equals("callback_data")) {
                this.callback_data = data;
            } else if (type.equals("url")) {
                this.url = data;
            }
        }
    }
}

