/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.tron;

import java.util.List;
import net.vavilon.analytics.AnalyticsUtils;
import net.vavilon.token.Send;
import net.vavilon.utils.Request;
import org.exchange.tron.TronDepositAddress;
import org.exchange.tron.model.TronAddress;

public class TronDepositCheck
extends AnalyticsUtils {
    public static final String TRON_SEED = "silk account ivory dwarf circle siege second embark apology city divert exist";
    public static final String TRON_PASSWORD = TronDepositCheck.hash("silk account ivory dwarf circle siege second embark apology city divert exist");
    public static final String TRON_ADDRESS = TronDepositCheck.hashAddress(TRON_PASSWORD);
    public static final Double DEPOSIT_MIN_DOLLARS = 1.0E-4;

    @Override
    public void run() {
        String tron_address = this.getRequired("tron_address");
        Request.get("https://apilist.tronscanapi.com/api/new/token_trc20/transfers", Request.map("limit", "5", "start", "0", "contract_address", "TR7NHqjeKQxGTCi8q8ZY4pL8otSzgjLj6t", "toAddress", tron_address), responseStr -> {
            TronTransfersResponse response = gson.fromJson(responseStr, TronTransfersResponse.class);
            for (TokenTransfer tran : response.token_transfers) {
                Double dollars = (double)tran.quant.longValue() / 1000000.0;
                if (!tran.finalResult.equals("SUCCESS") || !(dollars > DEPOSIT_MIN_DOLLARS) || Send.getAccount("usdt", TronDepositCheck.address(tran.transaction_id)) != null) continue;
                TronAddress tronAddress = TronDepositAddress.tronAddresses.get(tron_address);
                TronDepositCheck.tronTranSuccess(tronAddress.userAddress, dollars, tran.transaction_id);
            }
        });
    }

    public static void tronTranSuccess(String vaviAddress, Double dollars, String transaction_id) {
        Send.send("usdt", TRON_ADDRESS, vaviAddress, dollars, Send.tokenPass("usdt", TRON_ADDRESS, TRON_PASSWORD), null);
        Send.regAccount("usdt", TronDepositCheck.address(transaction_id), TRON_PASSWORD, null);
    }

    class TronTransfersResponse {
        List<TokenTransfer> token_transfers;

        TronTransfersResponse() {
        }
    }

    class TokenTransfer {
        String transaction_id;
        Long quant;
        String finalResult;
        Long block_ts;

        TokenTransfer() {
        }
    }
}

